//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Register
{
    string      Name,
                Surname,
                Address,
                Position;
    double      Remuneration;
    datetime    Birth,
                Hiring;
};
//+------------------------------------------------------------------+
void OnStart(void)
{   
    st_Register Record[10];
    uchar       Counter = 0,
                Index;

    Index = Counter;
    Counter += (NewRecord(Record[Counter], "Daniel", "Jose", "Brasil", "1971/03/30") ? 1 : 0);
    Record[Index] = UpdatePosition(Record[Index], "Chief Programmer");
    Index = Counter;
    Counter += (NewRecord(Record[Counter], "Edimarcos", "Alcantra", "Brasil", "1974/12/07") ? 1 : 0);
    Record[Index] = UpdatePosition(Record[Index], "Programmer");
    Index = Counter;
    Counter += (NewRecord(Record[Counter], "Carlos", "Almeida", "Brasil", "1985/11/15") ? 1 : 0);
    Record[Index] = UpdatePosition(Record[Index], "Junior Programmer");
    Index = Counter;
    Counter += (NewRecord(Record[Counter], "Yara", "Alves", "Brasil", "1978/07/25") ? 1 : 0);
    Record[Index] = UpdatePosition(Record[Index], "Accounting");

    Print("Number of records: ", Counter);
    ViewRecord(Record[3]);
}
//+------------------------------------------------------------------+
bool NewRecord(st_Register &arg, const string Name, const string Surname, const string Address, const string Birth)
{
    arg.Name = Name;
    arg.Surname = Surname;
    arg.Address = Address;
    arg.Birth = StringToTime(Birth);
    arg.Hiring = TimeLocal();

    return true;
}
//+------------------------------------------------------------------+
st_Register UpdatePosition(const st_Register &arg, const string NewPosition)
{
    st_Register info = arg;

    info.Position = NewPosition;

    return info;
}
//+------------------------------------------------------------------+
void ViewRecord(const st_Register &arg)
{
    PrintFormat("Collaborator: %s, %s\nPosition: %s\nBirth in: %s",
                    arg.Surname,
                    arg.Name,
                    arg.Position,
                    TimeToString(arg.Birth, TIME_DATE));
}
//+------------------------------------------------------------------+